<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

try {
    $serial_numbers = json_decode($_POST['serial_numbers'], true);
    
    if (!is_array($serial_numbers)) {
        throw new Exception('Invalid serial numbers format');
    }
    
    // Clean and validate serial numbers
    $serial_numbers = array_map('trim', $serial_numbers);
    $serial_numbers = array_filter($serial_numbers); // Remove empty values
    
    if (empty($serial_numbers)) {
        throw new Exception('No valid serial numbers provided');
    }
    
    // Check for duplicates in the input
    if (count($serial_numbers) !== count(array_unique($serial_numbers))) {
        throw new Exception('Duplicate serial numbers are not allowed');
    }
    
    // Check against existing serial numbers in the database
    $stmt = $pdo->prepare("
        SELECT serial_numbers 
        FROM supplier_receipts 
        WHERE serial_numbers IS NOT NULL 
        AND serial_numbers != 'null'
    ");
    $stmt->execute();
    
    $existing_serials = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if (!empty($row['serial_numbers'])) {
            $stored_serials = json_decode($row['serial_numbers'], true);
            if (is_array($stored_serials)) {
                $existing_serials = array_merge($existing_serials, $stored_serials);
            }
        }
    }
    
    // Check for duplicates
    $duplicates = array_intersect($serial_numbers, $existing_serials);
    if (!empty($duplicates)) {
        throw new Exception('One or more serial numbers already exist in the system: ' . implode(', ', $duplicates));
    }
    
    // Validate format of serial numbers (optional - add your specific format requirements)
    foreach ($serial_numbers as $serial) {
        if (strlen($serial) < 3) {
            throw new Exception('Serial numbers must be at least 3 characters long');
        }
        // Add more format validation as needed
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Serial numbers are valid and unique'
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
} 